<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-23
 * 版本：V1.0
 ****************************************/

require('../include/loader.php');
@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 admin_sort.php 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

$id = getGP( 'id','G','int' );
$action = getGP( 'action','G' );

switch( $action ) {
	case "AddSort":
		sort_add_data();
		break;
	case "EditSort":
		sort_edit_data();
		break;
	case "DelSort":
		sort_del_data();
		break;
	case "DataCheckExe":
		data_check_exe();
		break;
}

function sort_add_data() {
	global $db;
	$name = trim( getGP( 'Name','P' ) );
	$alias = trim( getGP( 'Alias','P' ) );
	$description = trim( getGP( 'Description','P' ) );
	$num = getGP( 'Num','P','int' );
	// 对 $alias 进行检查
	$sort_folder = XKLOG_ROOT . 'Article/' . $alias . '/';
	if( !writeable( $sort_folder ) ) {
		show_admin_message( '创建文件夹失败，分类添加失败', 'admin_sort.php?action=Sort' );
		exit;
	}
	$db->query( "INSERT INTO `" . PREFIX_STR . "Category` (`Num`,`Name`,`Alias`,`Description`,`ArticleNum`) VALUES ($num,'$name','$alias','$description',0)" );
	cache_category();
	show_admin_message( '添加分类成功', 'admin_sort.php?action=Sort' );
	exit;
}

function writeable($var) {
	$result = false;
	if ( !is_dir($var) ) {
		@mkdir($var, 0777);
	}
	if ( is_dir($var) ) {
		$var .= 'temp.txt';
		if ( ($fp=@fopen($var, 'wb')) && (@fwrite($fp, 'XKLog')) ) {
			@fclose($fp);
			@unlink($var);
			$result = true;
		}
	}
	return $result;
}

function sort_edit_data() {
	/*// 还需修改文件夹名称、文章中的分类名称
	Rs.Open "select * from " & PrefixStr & "Sort where SID=" & id, Conn, 2, 3
	Rs("Num") = SafeNumChecker( Request.Form("Num") )
	Rs("Name") = Request.Form("Name")
	Rs("Description") = Request.Form("Description")
	Rs.Update
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
	Cache_Category()
	Show_AdminMessage "修改分类成功", "admin_sort.php?action=Sort"
	Response.End*/
	show_admin_message( '抱歉，此功能尚未完成', 'admin_sort.php?action=Sort' );
	exit;
}

function sort_del_data() {
	global $db,$id;
	$article_num = $db->result( "select count(ID) from `" . PREFIX_STR . "Article` where IsDel=0 And Category=$id" );
	if( $article_num != 0 ) {
		show_admin_message( '这个分类不是空的，不能删除', 'admin_sort.php?action=Sort' );
	}else{
		$db->query( "DELETE FROM `" . PREFIX_STR . "Category` WHERE CID=$id" );
		cache_category();
		show_admin_message( '分类删除成功', 'admin_sort.php?action=Sort' );
	}
	exit;
}

function data_check_exe() {
	global $_CACHE,$db;
	If( count( $_CACHE['category'] ) == 0 ) {
		show_admin_message( '尚无文章分类', 'admin_sort.php' );
		exit;
	}else{
		foreach( $_CACHE['category'] as $category ) {
			$cid = $category['CID'];
			$article_num = $db->result( "select count(ID) from `" . PREFIX_STR . "Article` where IsDel=0 And Category=$cid" );
			if( $category['ArticleNum'] != $article_num ) {
				$db->query( "UPDATE `" . PREFIX_STR . "Category` SET ArticleNum=$article_num WHERE CID=$cid" );
			}
		}
	}
	cache_category();
	show_admin_message( '分类数据已经重新统计', get_http_referer() );
	exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "../Include/Style.css" />
	<script language="javascript" type="text/javascript" src="../Include/admin.js"></script>
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">分类管理</div>
		<div class = "Admin_Content">
		<div style="padding:5px;margin:2px;border:1px solid #96C2F1;background-color: #EFF7FF;"><a href="admin_sort.php?action=Sort">已有分类</a> | <a href="admin_sort.php?action=Add">新增分类</a> | <a href="admin_sort.php?action=DataCheck">数据修正</a></div>
<?php

switch( $action )
{
	case "Sort":
		sort_list();
		break;
	case "Add":
		sort_add();
		break;
	case "Edit":
		sort_edit();
		break;
	case "DataCheck":
		data_check();
		break;
	default:
		main();
}

function sort_list() {
	global $db;
	$sql = 'select * from ' . PREFIX_STR . 'Category order by Num asc,CID desc';
	$sort_array = $db->fetch_all( $sql );
?>
			<div style="padding:5px;margin:2px;">
				<table style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()" onmouseout="changeback()">
					<tr align="center" height="22" bgcolor="#ffffff">
						<td width="3%"  background="../Include/bg.gif"></td>
						<td width="3%"  background="../Include/bg.gif">序号</td>
						<td width="20%" background="../Include/bg.gif">分类名称</td>
						<td width="14%" background="../Include/bg.gif">分类别名</td>
						<td width="6%" background="../Include/bg.gif">分类排序</td>
						<td width="35%" background="../Include/bg.gif">分类描述</td>
						<td width="6%" background="../Include/bg.gif">文章数量</td>
						<td width="13%" background="../Include/bg.gif">管理操作</td>
					</tr>
					<?php
					$i = 1;
					foreach( $sort_array as $value ) {
					?>
					<tr align="center" height="20" bgcolor="#ffffff">
						<td ></td>
						<td><?php echo $i ?></td>
						<td><?php echo $value['Name'] ?></td>
						<td><?php echo $value['Alias'] ?></td>
						<td><?php echo $value['Num'] ?></td>
						<td><?php echo $value['Description'] ?></td>
						<td><?php echo $value['ArticleNum'] ?></td>
						<td><img src="../Include/edt.gif" width="16" height="16" /><span class="Control"><a href="admin_sort.php?action=Edit&id=<?php echo $value['CID'] ?>">编辑</a>&nbsp; &nbsp;<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('删除分类不可恢复！确实要删除吗?'))location='admin_sort.php?action=DelSort&id=<?php echo $value['CID'] ?>'">删除</a></span></td>
					</tr>
					<?php
						$i ++;
					}
					?>
				</table>
			</div>
			<div class="Main_Button"></div>
<?php
}

function sort_add() {
?>
			<fieldset>
			<legend> 添加分类</legend>
				<div align="left">      
				<table border="0" cellpadding="2" cellspacing="1">
				<form action="admin_sort.php?action=AddSort" method="post">
					<tr>
						<td width="180"><div align="right">分类名称&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Name" type="text" size="30" maxlength="50" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">分类别名&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Alias" type="text" size="30" maxlength="50" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">分类描述&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Description" type="text" size="30" maxlength="100" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">分类排序&nbsp;&nbsp;<div class="Main_Tips">必须是大于0的数字</div></div></td>
						<td align="left"><input name="Num" type="text" size="30" maxlength="10" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right"></div></td>
						<td align="left"><input type="submit" name="functionmit" class="Main_Button" value="添加" /></td>
					</tr>
				</form>
				</table>
			</fieldset>
			<div class="Main_Button"></div>
<?php
}

function sort_edit() {
	global $db;
	$id = getGP( 'id','G','int' );
	$sql = "select * from `" . PREFIX_STR . "Category` where CID=$id";
	$sort_array = $db->fetch_one_array( $sql );
?>
			<fieldset>
			<legend> 修改分类</legend>
				<div align="left">      
				<table border="0" cellpadding="2" cellspacing="1">
				<form action="admin_sort.php?action=EditSort&id=<?php echo $id ?>" method="post">
					<tr>
						<td width="180"><div align="right">分类名称&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Name" type="text" size="30" maxlength="50" class="Main_Text" value="<?php echo $sort_array['Name'] ?>" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">分类别名&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Alias" type="text" size="30" maxlength="50" class="Main_Text" value="<?php echo $sort_array['Alias'] ?>" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">分类描述&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Description" type="text" size="30" maxlength="100" class="Main_Text" value="<?php echo $sort_array['Description'] ?>" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">分类排序&nbsp;&nbsp;<div class="Main_Tips">必须是大于0的数字</div></div></td>
						<td align="left"><input name="Num" type="text" size="30" maxlength="10" class="Main_Text" value="<?php echo $sort_array['Num'] ?>" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right"></div></td>
						<td align="left"><input type="submit" name="functionmit" class="Main_Button" value="修改" /></td>
					</tr>
				</form>
				</table>
			</fieldset>
			<div class="Main_Button"></div>
<?php
}

function data_check() {
?>
						<div style="padding:10px;">
							<a href="admin_sort.php?action=DataCheckExe">重新统计分类数据</a>
						</div>
<?php
}

function main() {
?>
						<div style="padding:10px;">
							欢迎进行 <b>分类管理</b>，文章分类是 XKLog 进行内容管理和信息组织的重要依据。
						</div>
<?php
}
?>
		</div>
	</div>

	<div id="Foot"><?php show_run_info() ?></div>
</center>
</div>
</body>
</html>